/*
 * QrfeGlobal.h
 *
 *  Created on: 28.07.2011
 *      Author: stefan.detter
 */

#ifndef QRFEGLOBAL_H_
#define QRFEGLOBAL_H_

#include <QObject>
#include <QByteArray>
#include <QString>

namespace QrfeGlobal
{
	QString 	bytesToString ( const QByteArray& epc );
	QByteArray 	stringToBytes ( const QString& epcString, bool * ok = 0 );

    QByteArray  appendBits(const QByteArray& base, int targetBitPos, quint64 value, int valueBitCount);
    quint64     extractValue(const QByteArray& base, int targetBitPos, int valueBitCount);

	QByteArray 	xorByteArray ( const QByteArray& data, const QByteArray& xdata);

	QString 	getWrappedString ( const QString& string, int wrapAfterCount );

	ulong 		bitCountTobyteCount( const ulong bitCount );

	template <typename T>
	QByteArray 	arrayToQByteArray ( T * data, uint size, bool bigEndian = false )
	{
		QByteArray res;
		res.resize(size * sizeof(T));

		quint32 index;
		index = 0;

		for(uint i = 0; i < size; i++ )
		{
			if(!bigEndian)
			{
				for(uint j = 0; j < sizeof(T); j++)
				{
					res[index++] = (uchar)(data[i] >> (j*8));
				}
			}
			else
			{
				for(uint j = sizeof(T); j > 0; j--)
				{
					res[index++] = (uchar)(data[i] >> ((j-1)*8));
				}
			}
		}

		return res;
	}

    template <typename T>
    QByteArray toQByteArray ( T data, bool bigEndian = false )
    {
        return QrfeGlobal::arrayToQByteArray(&data, 1, bigEndian);
    }

	template <typename T>
	bool 		isListInList (const QList<T>& source, const QList<T>& values)
	{
		foreach(T val, values)
		{
			if(!source.contains(val))
				return false;
		}
		return true;
	}
}

#endif /* QRFEGLOBAL_H_ */
